/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.levelhead.core;

import club.sk1er.mods.levelhead.Levelhead;
import club.sk1er.mods.levelhead.config.DisplayConfig;
import club.sk1er.mods.levelhead.config.MasterConfig;
import club.sk1er.mods.levelhead.core.DisplayManager;
import club.sk1er.mods.levelhead.core.ExtensionsKt;
import club.sk1er.mods.levelhead.display.AboveHeadDisplay;
import club.sk1er.mods.levelhead.display.ChatDisplay;
import club.sk1er.mods.levelhead.display.LevelheadDisplay;
import club.sk1er.mods.levelhead.display.LevelheadTag;
import club.sk1er.mods.levelhead.display.TabDisplay;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.wrappers.UPlayer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020\u001cR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lclub/sk1er/mods/levelhead/core/DisplayManager;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "aboveHead", "", "Lclub/sk1er/mods/levelhead/display/AboveHeadDisplay;", "getAboveHead", "()Ljava/util/List;", "<set-?>", "Lclub/sk1er/mods/levelhead/display/ChatDisplay;", "chat", "getChat", "()Lclub/sk1er/mods/levelhead/display/ChatDisplay;", "config", "Lclub/sk1er/mods/levelhead/config/MasterConfig;", "getConfig", "()Lclub/sk1er/mods/levelhead/config/MasterConfig;", "setConfig", "(Lclub/sk1er/mods/levelhead/config/MasterConfig;)V", "getFile", "()Ljava/io/File;", "Lclub/sk1er/mods/levelhead/display/TabDisplay;", "tab", "getTab", "()Lclub/sk1er/mods/levelhead/display/TabDisplay;", "adjustIndices", "", "checkCacheSizes", "clearCache", "joinWorld", "playerJoin", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "readConfig", "saveConfig", "update", "Levelhead 1.8.9"})
public final class DisplayManager {
    @NotNull
    private final File file;
    @NotNull
    private MasterConfig config;
    @NotNull
    private final List<AboveHeadDisplay> aboveHead;
    private ChatDisplay chat;
    private TabDisplay tab;

    public DisplayManager(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.config = new MasterConfig();
        this.aboveHead = new ArrayList();
        this.readConfig();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final MasterConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull MasterConfig masterConfig) {
        Intrinsics.checkNotNullParameter((Object)masterConfig, (String)"<set-?>");
        this.config = masterConfig;
    }

    @NotNull
    public final List<AboveHeadDisplay> getAboveHead() {
        return this.aboveHead;
    }

    @NotNull
    public final ChatDisplay getChat() {
        ChatDisplay chatDisplay = this.chat;
        if (chatDisplay != null) {
            return chatDisplay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chat");
        return null;
    }

    @NotNull
    public final TabDisplay getTab() {
        TabDisplay tabDisplay = this.tab;
        if (tabDisplay != null) {
            return tabDisplay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tab");
        return null;
    }

    public final void readConfig() {
        try {
            Unit unit;
            DisplayManager displayManager;
            Object it;
            JsonElement jsonElement;
            Object object;
            boolean shouldSaveCopyNow = false;
            if (!this.file.exists()) {
                this.file.createNewFile();
                shouldSaveCopyNow = true;
            }
            Object object2 = Levelhead.INSTANCE.getJsonParser().parse(FileUtils.readFileToString((File)this.file, (Charset)Charsets.UTF_8));
            boolean bl = false;
            try {
                object = Result.Companion;
                JsonElement $this$readConfig_u24lambda_u2d0 = object2;
                boolean bl2 = false;
                $this$readConfig_u24lambda_u2d0 = $this$readConfig_u24lambda_u2d0.getAsJsonObject();
                bl2 = false;
                object = Result.constructor-impl((Object)$this$readConfig_u24lambda_u2d0);
            }
            catch (Throwable $this$readConfig_u24lambda_u2d0) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$readConfig_u24lambda_u2d0));
            }
            object2 = object;
            bl = false;
            boolean bl4 = false;
            Object object3 = Result.exceptionOrNull-impl((Object)object2);
            if (object3 == null) {
                jsonElement = object2;
            } else {
                it = object3;
                boolean bl5 = false;
                jsonElement = new JsonObject();
            }
            JsonObject source = (JsonObject)jsonElement;
            if (source.has("master")) {
                object2 = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("master").getAsJsonObject(), MasterConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson(source[\"ma\u2026MasterConfig::class.java)");
                this.config = (MasterConfig)object2;
            }
            if (source.has("head")) {
                for (JsonElement head : source.get("head").getAsJsonArray()) {
                    object3 = Levelhead.INSTANCE.getGson().fromJson((JsonElement)head.getAsJsonObject(), DisplayConfig.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"gson.fromJson(head.asJso\u2026isplayConfig::class.java)");
                    this.aboveHead.add(new AboveHeadDisplay((DisplayConfig)object3));
                }
            }
            if (this.aboveHead.isEmpty()) {
                this.aboveHead.add(new AboveHeadDisplay(new DisplayConfig()));
            }
            if (source.has("chat")) {
                object2 = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("chat").getAsJsonObject(), DisplayConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson(source[\"ch\u2026isplayConfig::class.java)");
                this.chat = new ChatDisplay((DisplayConfig)object2);
            } else {
                object2 = new DisplayConfig();
                boolean bl6 = false;
                boolean bl7 = false;
                it = object2;
                displayManager = this;
                boolean bl8 = false;
                ((DisplayConfig)it).setType("GUILD_NAME");
                unit = Unit.INSTANCE;
                Object object4 = object2;
                displayManager.chat = new ChatDisplay((DisplayConfig)object4);
            }
            if (source.has("tab")) {
                object2 = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("tab").getAsJsonObject(), DisplayConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson(source[\"ta\u2026isplayConfig::class.java)");
                this.tab = new TabDisplay((DisplayConfig)object2);
            } else {
                object2 = new DisplayConfig();
                boolean bl9 = false;
                boolean bl10 = false;
                it = object2;
                displayManager = this;
                boolean bl11 = false;
                ((DisplayConfig)it).setType("QUESTS");
                unit = Unit.INSTANCE;
                Object object5 = object2;
                displayManager.tab = new TabDisplay((DisplayConfig)object5);
            }
            this.adjustIndices();
            if (shouldSaveCopyNow) {
                this.saveConfig();
            }
        }
        catch (IOException e) {
            Levelhead.INSTANCE.getLogger().error("Failed to initialize display manager.", (Throwable)e);
        }
    }

    public final void saveConfig() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("master", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.config));
        jsonObject.add("tab", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.getTab().getConfig()));
        jsonObject.add("chat", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.getChat().getConfig()));
        JsonArray head = new JsonArray();
        Iterable $this$forEach$iv = this.aboveHead;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AboveHeadDisplay display = (AboveHeadDisplay)element$iv;
            boolean bl = false;
            head.add(Levelhead.INSTANCE.getGson().toJsonTree((Object)display.getConfig()));
        }
        jsonObject.add("head", (JsonElement)head);
        try {
            FileUtils.writeStringToFile((File)this.file, (String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Levelhead.INSTANCE.getLogger().error("Failed to write to config.", (Throwable)e);
        }
    }

    public final void adjustIndices() {
        int n = 0;
        int n2 = this.aboveHead.size() + -1;
        if (n <= n2) {
            do {
                int i;
                this.aboveHead.get(i).setBottomValue((i = n++) == 0);
                this.aboveHead.get(i).setIndex(i);
            } while (n <= n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void joinWorld() {
        List list;
        Object object;
        Object object2;
        EntityPlayer $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        List list2 = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Iterable $this$joinWorld_u24lambda_u2d6 = list2;
        boolean bl5 = false;
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getChat()) {
            $this$joinWorld_u24lambda_u2d6.add(this.getChat());
        }
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getTab()) {
            $this$joinWorld_u24lambda_u2d6.add(this.getTab());
        }
        Iterable iterable = this.getAboveHead();
        List list3 = $this$joinWorld_u24lambda_u2d6;
        boolean $i$f$filterIndexed = false;
        void var12_17 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl7 = false;
            object = (AboveHeadDisplay)element$iv$iv;
            int i = index$iv$iv;
            boolean bl8 = false;
            if (!(i <= Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        list3.addAll(list4);
        List displays = CollectionsKt.build((List)list2);
        WorldClient worldClient = UMinecraft.getWorld();
        if (worldClient != null && (list = worldClient.field_73010_i) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            $this$joinWorld_u24lambda_u2d6 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                $this$filterIndexedTo$iv$iv = (EntityPlayer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl9 = false;
                Iterable $this$map$iv2 = displays;
                boolean $i$f$map2 = false;
                Iterable $i$f$forEachIndexed2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    void playerInfo;
                    LevelheadDisplay levelheadDisplay = (LevelheadDisplay)item$iv$iv2;
                    object2 = destination$iv$iv3;
                    boolean bl10 = false;
                    UUID uUID = playerInfo.func_110124_au();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerInfo.uniqueID");
                    object = new Levelhead.LevelheadRequest(ExtensionsKt.getTrimmed(uUID), (LevelheadDisplay)it, it instanceof AboveHeadDisplay ? ((AboveHeadDisplay)it).getBottomValue() : false, null, 8, null);
                    object2.add((Object)object);
                }
                List list5 = (List)destination$iv$iv3;
                collection.add(list5);
            }
            list2 = (List)destination$iv$iv2;
            List list6 = CollectionsKt.flatten((Iterable)list2);
            if (list6 != null) {
                CollectionsKt.chunked((Iterable)list6, (int)20, (Function1)joinWorld.2.INSTANCE);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void playerJoin(@NotNull EntityPlayer player) {
        void $this$mapTo$iv$iv;
        LevelheadDisplay it;
        Iterable $this$filterTo$iv$iv;
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (ExtensionsKt.isNPC(player)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Iterable iterable = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        List $this$playerJoin_u24lambda_u2d10 = iterable;
        boolean bl5 = false;
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getChat()) {
            $this$playerJoin_u24lambda_u2d10.add(this.getChat());
        }
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getTab()) {
            $this$playerJoin_u24lambda_u2d10.add(this.getTab());
        }
        Iterable iterable2 = this.getAboveHead();
        List list = $this$playerJoin_u24lambda_u2d10;
        boolean $i$f$filterIndexed = false;
        void var13_21 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl7 = false;
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)element$iv$iv;
            int i = index$iv$iv;
            boolean bl8 = false;
            if (!(i <= Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        list.addAll(list2);
        List displays = CollectionsKt.build((List)iterable);
        Iterable $this$filter$iv = displays;
        boolean $i$f$filter = false;
        iterable = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LevelheadDisplay)element$iv$iv;
            boolean bl9 = false;
            if (!(!it.getCache().containsKey(player.func_110124_au()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LevelheadDisplay)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl10 = false;
            UUID uUID = player.func_110124_au();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueID");
            Levelhead.LevelheadRequest levelheadRequest = new Levelhead.LevelheadRequest(ExtensionsKt.getTrimmed(uUID), it, it instanceof AboveHeadDisplay ? ((AboveHeadDisplay)it).getBottomValue() : false, null, 8, null);
            collection.add(levelheadRequest);
        }
        Collection collection = (List)destination$iv$iv2;
        bl2 = false;
        if (collection.isEmpty()) {
            boolean bl11 = false;
            return;
        }
        bl2 = false;
        boolean bl12 = false;
        List $this$playerJoin_u24lambda_u2d14 = (List)collection;
        boolean bl13 = false;
        Levelhead.INSTANCE.fetch($this$playerJoin_u24lambda_u2d14);
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        LevelheadTag tag2;
        Map.Entry element$iv;
        Object object;
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i == 0 && Levelhead.LevelheadPurchaseStates.INSTANCE.getCustomLevelhead() || i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            Map $this$forEach$iv = head.getCache();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl3 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry $dstr$_u24__u24$tag = element$iv2 = iterator.next();
                boolean bl4 = false;
                Object object2 = $dstr$_u24__u24$tag;
                boolean bl5 = false;
                LevelheadTag tag3 = (LevelheadTag)object2.getValue();
                if (Intrinsics.areEqual((Object)tag3.getOwner(), (Object)UPlayer.getUUID()) && i == 0 && Levelhead.LevelheadPurchaseStates.INSTANCE.getCustomLevelhead()) continue;
                object2 = tag3.getHeader();
                bl5 = false;
                boolean bl6 = false;
                Object $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15 = object2;
                boolean bl7 = false;
                ((LevelheadTag.LevelheadComponent)$this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15).setChroma(head.getConfig().getHeaderChroma());
                ((LevelheadTag.LevelheadComponent)$this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15).setColor(head.getConfig().getHeaderColor());
                ((LevelheadTag.LevelheadComponent)$this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15).setValue(Intrinsics.stringPlus((String)head.getConfig().getHeaderString(), (Object)": "));
                object2 = tag3.getFooter();
                bl5 = false;
                bl6 = false;
                Object $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16 = object2;
                boolean bl8 = false;
                ((LevelheadTag.LevelheadComponent)$this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16).setChroma(head.getConfig().getFooterChroma());
                ((LevelheadTag.LevelheadComponent)$this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16).setColor(head.getConfig().getFooterColor());
            }
        }
        LevelheadDisplay levelheadDisplay = this.getChat();
        boolean bl = false;
        boolean bl9 = false;
        ChatDisplay $this$update_u24lambda_u2d22 = levelheadDisplay;
        boolean bl10 = false;
        Map $this$forEach$iv = $this$update_u24lambda_u2d22.getCache();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl11 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$_u24__u24$tag = element$iv = iterator.next();
            boolean bl12 = false;
            Object object3 = $dstr$_u24__u24$tag;
            boolean bl13 = false;
            tag2 = (LevelheadTag)object3.getValue();
            object3 = tag2.getHeader();
            bl13 = false;
            boolean bl14 = false;
            Object it = object3;
            boolean bl15 = false;
            ((LevelheadTag.LevelheadComponent)it).setChroma($this$update_u24lambda_u2d22.getConfig().getHeaderChroma());
            ((LevelheadTag.LevelheadComponent)it).setColor($this$update_u24lambda_u2d22.getConfig().getHeaderColor());
            object3 = tag2.getFooter();
            bl13 = false;
            bl14 = false;
            it = object3;
            boolean bl16 = false;
            ((LevelheadTag.LevelheadComponent)it).setChroma($this$update_u24lambda_u2d22.getConfig().getFooterChroma());
            ((LevelheadTag.LevelheadComponent)it).setColor($this$update_u24lambda_u2d22.getConfig().getFooterColor());
        }
        levelheadDisplay = this.getTab();
        bl = false;
        bl9 = false;
        LevelheadDisplay $this$update_u24lambda_u2d26 = levelheadDisplay;
        boolean bl17 = false;
        $this$forEach$iv = $this$update_u24lambda_u2d26.getCache();
        $i$f$forEach = false;
        object = $this$forEach$iv;
        bl11 = false;
        iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$_u24__u24$tag = element$iv = iterator.next();
            boolean bl18 = false;
            Object object4 = $dstr$_u24__u24$tag;
            boolean bl19 = false;
            tag2 = (LevelheadTag)object4.getValue();
            object4 = tag2.getHeader();
            bl19 = false;
            boolean bl20 = false;
            Object it = object4;
            boolean bl21 = false;
            ((LevelheadTag.LevelheadComponent)it).setChroma($this$update_u24lambda_u2d26.getConfig().getHeaderChroma());
            ((LevelheadTag.LevelheadComponent)it).setColor($this$update_u24lambda_u2d26.getConfig().getHeaderColor());
            object4 = tag2.getFooter();
            bl19 = false;
            bl20 = false;
            it = object4;
            boolean bl22 = false;
            ((LevelheadTag.LevelheadComponent)it).setChroma($this$update_u24lambda_u2d26.getConfig().getFooterChroma());
            ((LevelheadTag.LevelheadComponent)it).setColor($this$update_u24lambda_u2d26.getConfig().getFooterColor());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkCacheSizes() {
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            head.checkCacheSize();
        }
        this.getChat().checkCacheSize();
        this.getTab().checkCacheSize();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearCache() {
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            head.getCache().clear();
        }
        this.getChat().getCache().clear();
        this.getTab().getCache().clear();
        this.joinWorld();
    }
}

